<?php ob_start(); ?>
<?php include_once('include/header.inc.php'); ?>

<div class="my-3 my-md-5">
    <div class="container">

        <div class="row">
            <form method="POST" class="col-12 card">

                <div class="card-header">
                    <h3 class="card-title">Create New Wallet</h3>
                </div>




 					<div class="card-body">



	                  	<div class="row">

		                    <div class="col-md-12 col-lg-4">
		                      <div class="form-group">
		                        <label class="form-label">Wallet Name</label>
									<input type='text' class="form-control" readonly="" value='Wallet' placeholder="Wallet Name" name="wallet_name" id="wallet_name" required="">
		                      </div>
		                    </div>

		                    <div class="col-md-12 col-lg-4">
		                      <div class="form-group">
		                        <label class="form-label"> Wallet Currency </label>
								    <select class="form-control" name="wallet_currency" id="wallet_currency">
                                    <?php 

                                    foreach ($currencies_codes as $Currency_code => $Currency_name) {
                                        echo "<option value='$Currency_code'>$Currency_code - $Currency_name</option>";
                                    }

                                    ?>
								    </select>
		                      </div>
		                    </div>


		                    <div class="col-md-12 col-lg-4">
		                      <div class="form-group">
		                        <label class="form-label"> Currency Symbole </label>
								    <select class="form-control" name="wallet_currency_symbole" id="wallet_currency_symbole">
                                    <option disabled="" hidden="" selected="">Select Symbole</option>
                                    <?php 

                                    foreach ($currencies_symboles as $Currency_code => $Currency_symbole) {
                                        echo "<option value='$Currency_symbole'>$Currency_symbole ($Currency_code)</option>";
                                    }

                                    ?>
								    </select>
		                      </div>
		                    </div>



	                	</div>




	                	<div class="row">
	                		
		                    <div class="col-md-12 col-lg-12">
		                      <div class="form-group">
		                        <label class="form-label">Payment Insturctions</label>
			                        <textarea class="form-control" name="payment_instructions" id="editor"></textarea>
		                      </div>
		                    </div>

	                	</div>


 					</div>


	                <div class="card-footer text-right ">

	                	<button class="btn btn-success" name="create_wallet" id="create_wallet"> Create Wallet </button>

	                 </div>

 				</form>


 			</div>







<div class='col-lg-12 col-md-12 card'>

		<div class="card-header">
			<h3 class="card-title">Wallets</b></h3>
		</div>

        <div class="card-body">

  <table id="wallets_list_table" class="table table-striped table-bordered"  style="width:100%">
        <thead>
            <tr>
                <th>Currency</th>
                <th>Currency Symbole</th>
                <th>Is Default</th>
                <th>Add Date</th>
                <th>Status</th>
                <th>A</th>
            </tr>
        </thead>
        <tbody>




<?php

		$WALLETS_query           =        $db->query("SELECT * FROM wallets");
		$WALLET_EXIST            =        $WALLETS_query->num_rows;

		while ($WALLET = $WALLETS_query->fetch_assoc() ) {
		  $table_name                 =   $WALLET['table_name'];
		  $wallet_id                  =   $WALLET['id'];
		  $wallet_name                =   $WALLET['wallet_name'];
		  $wallet_currency            =   $WALLET['wallet_currency'];
		  $wallet_currency_symbole    =   $WALLET['wallet_currency_symbole'];
		  $wallet_instructions        =   $WALLET['wallet_instructions'];
		  $wallet_default        	  =   $WALLET['is_default'];
		  $add_date                   =   $WALLET['add_date'];
		  $status                     =   $WALLET['status'];

		  switch ($status) {
		  	case 0:
		  		$statuss 	=	"OFF";
		  		break;
		  	
		  	case 1:
		  		$statuss 	=	"ON";
		  		break;		  	

		  	default:
		  		$statuss 	=	"";
		  		break;
		  }




		  switch ($wallet_default) {
		  	case 0:
		  		$wallet_defaults 	=	

		  		"
					  <a href='action.php?wallet-settings&wallet_id=$wallet_id' class='form-group' >
					    <a href='action.php?wallet-settings&wallet_id=$wallet_id' class='custom-switch'>
					      <input type='checkbox' name='custom-switch-checkbox' class='custom-switch-input'>
					      <span class='custom-switch-indicator'></span>
					      <span class='custom-switch-description'>No</span>
					    </a>
					  </a>
		  		";
		  		break;
		  	
		  	case 1:
		  		$wallet_defaults 	=

		  		"
					  <div class='form-group' >
					    <label class='custom-switch'>
					      <input type='checkbox' name='custom-switch-checkbox' class='custom-switch-input' disabled checked>
					      <span class='custom-switch-indicator'></span>
					      <span class='custom-switch-description'>Yes</span>
					    </label>
					  </div>
				";
		  		break;

		  	default:
		  		$wallet_defaults 	=	"";
		  		break;
		  }



            echo "

                <tr>
                    <td><small>$wallet_currency</small></td>
                    <td>$wallet_currency_symbole</td>
                    <td>$wallet_defaults</td>
                    <td>$add_date</td>
                    <td>$statuss</td>
                    <td><a href='wallet_edit.php?wallet_id=$wallet_id'>Edit</a></td>
                </tr>
            ";
}

?>
        		</tbody>
    		</table>
        </div>
      </div>










 		</div>
  	</div>
</div>

<?php include_once('include/footer.inc.php'); ?>


<script type="text/javascript">
	ClassicEditor
	    .create( document.querySelector( '#editor' ) )
	    .catch( error => {
	        console.error( error );
	    } );
</script>

<?php 




	if (isset($_POST['create_wallet'])) {

        $CUR_wallet_name                         	= filter_var($_POST['wallet_name'],FILTER_SANITIZE_STRING);
        $CUR_wallet_currency                        = filter_var($_POST['wallet_currency'],FILTER_SANITIZE_STRING);
        $CUR_wallet_currency_symbole				= filter_var($_POST['wallet_currency_symbole'],FILTER_SANITIZE_STRING);
        $CUR_payment_instructions              		= $_POST['payment_instructions'];
        $CUR_wallet_default							= 0;
        $add_dateing                                = gmdate('Y-m-d');
        $status                                		= 1;
	
		$Table_name 								= strtolower($CUR_wallet_name."_".$CUR_wallet_currency);

		// sql to create Wallet table
		$sql = "CREATE TABLE $Table_name (
		id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
		user_id VARCHAR(30) NOT NULL,
		user_unique_id VARCHAR(30) NOT NULL,
		value VARCHAR(50),
		add_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
		)";


		// Create Table
		$db->query($sql) or die($db->error);


		// Create Information About Table
		$db->query("INSERT INTO wallets(table_name,wallet_name,wallet_currency,wallet_currency_symbole,wallet_instructions,is_default,add_date,status) 
			VALUES (
			'$Table_name',
			'$CUR_wallet_name',
			'$CUR_wallet_currency',
			'$CUR_wallet_currency_symbole',
			'$CUR_payment_instructions',
			'$CUR_wallet_default',
			'$add_dateing',
			'$status'
		)"
		);


		// ADD Wallet Option To the Topup Games Table
		$db->query("ALTER TABLE topup_games ADD COLUMN $Table_name TEXT NOT NULL");
		
		// ADD Wallet Option To the Games Table
		$db->query("ALTER TABLE games ADD COLUMN $Table_name TEXT NOT NULL");

		// ADD Wallet Option To the Internet Table
		$db->query("ALTER TABLE internet ADD COLUMN $Table_name TEXT NOT NULL");

		// ADD Wallet Option To the Giftcards Table
		$db->query("ALTER TABLE giftcards ADD COLUMN $Table_name TEXT NOT NULL");

		// ADD Wallet Option To the Channels Table
		$db->query("ALTER TABLE channels ADD COLUMN $Table_name TEXT NOT NULL");

		// ADD Wallet Option To the Iptvs Table
		$db->query("ALTER TABLE iptvs ADD COLUMN $Table_name TEXT NOT NULL");


		// Redirect User to the same Page
		header("Location: $_SERVER[PHP_SELF]");

	}else{

	}


?>








<!-- DataTable Script -->
<script type="text/javascript">
  $(document).ready(function() {
    var table = $('#wallets_list_table').DataTable( {
        dom: 'Bfrtip',
        buttons     : ['print','copy', 'excel','pageLength','pdf'],//*'csv'*/],
        paging      : true,
        lengthChange: true,
        searching   : true,
        ordering    : false,
        info        : false,
        autoWidth   : false,
        responsive  : true,

    } );

} );

</script>