<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_ContainerAnalysis_GrafeasV1beta1VulnerabilityDetails extends Google_Collection
{
  protected $collection_key = 'relatedUrls';
  public $cvssScore;
  public $effectiveSeverity;
  public $longDescription;
  protected $packageIssueType = 'Google_Service_ContainerAnalysis_PackageIssue';
  protected $packageIssueDataType = 'array';
  protected $relatedUrlsType = 'Google_Service_ContainerAnalysis_RelatedUrl';
  protected $relatedUrlsDataType = 'array';
  public $severity;
  public $shortDescription;
  public $type;

  public function setCvssScore($cvssScore)
  {
    $this->cvssScore = $cvssScore;
  }
  public function getCvssScore()
  {
    return $this->cvssScore;
  }
  public function setEffectiveSeverity($effectiveSeverity)
  {
    $this->effectiveSeverity = $effectiveSeverity;
  }
  public function getEffectiveSeverity()
  {
    return $this->effectiveSeverity;
  }
  public function setLongDescription($longDescription)
  {
    $this->longDescription = $longDescription;
  }
  public function getLongDescription()
  {
    return $this->longDescription;
  }
  /**
   * @param Google_Service_ContainerAnalysis_PackageIssue[]
   */
  public function setPackageIssue($packageIssue)
  {
    $this->packageIssue = $packageIssue;
  }
  /**
   * @return Google_Service_ContainerAnalysis_PackageIssue[]
   */
  public function getPackageIssue()
  {
    return $this->packageIssue;
  }
  /**
   * @param Google_Service_ContainerAnalysis_RelatedUrl[]
   */
  public function setRelatedUrls($relatedUrls)
  {
    $this->relatedUrls = $relatedUrls;
  }
  /**
   * @return Google_Service_ContainerAnalysis_RelatedUrl[]
   */
  public function getRelatedUrls()
  {
    return $this->relatedUrls;
  }
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  public function getSeverity()
  {
    return $this->severity;
  }
  public function setShortDescription($shortDescription)
  {
    $this->shortDescription = $shortDescription;
  }
  public function getShortDescription()
  {
    return $this->shortDescription;
  }
  public function setType($type)
  {
    $this->type = $type;
  }
  public function getType()
  {
    return $this->type;
  }
}
