<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_CloudFilestore_FileShareConfig extends Google_Collection
{
  protected $collection_key = 'nfsExportOptions';
  public $capacityGb;
  public $name;
  protected $nfsExportOptionsType = 'Google_Service_CloudFilestore_NfsExportOptions';
  protected $nfsExportOptionsDataType = 'array';
  public $sourceBackup;

  public function setCapacityGb($capacityGb)
  {
    $this->capacityGb = $capacityGb;
  }
  public function getCapacityGb()
  {
    return $this->capacityGb;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Google_Service_CloudFilestore_NfsExportOptions[]
   */
  public function setNfsExportOptions($nfsExportOptions)
  {
    $this->nfsExportOptions = $nfsExportOptions;
  }
  /**
   * @return Google_Service_CloudFilestore_NfsExportOptions[]
   */
  public function getNfsExportOptions()
  {
    return $this->nfsExportOptions;
  }
  public function setSourceBackup($sourceBackup)
  {
    $this->sourceBackup = $sourceBackup;
  }
  public function getSourceBackup()
  {
    return $this->sourceBackup;
  }
}
